<?php

//----=== use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthControllerNew;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PartiesTypeController;


Route::get('/', [AuthControllerNew::class, 'login']);
Route::post('login_post', [AuthControllerNew::class, 'login_post']);

Route::get('register', [AuthControllerNew::class, 'register']);
Route::post('register_post', [AuthControllerNew::class, 'register_post']);

Route::get('forgot_password', [AuthControllerNew::class, 'forgot_password']);
Route::post('forgot_password_post', [AuthControllerNew::class, 'forgot_password_post']);

Route::group(['middleware' => 'admin'], function(){
       Route::get('admin/dashboard', [DashboardController::class, 'dashboard']);
       Route::get('admin/parties_type', [PartiesTypeController::class, 'parties_type']);
       Route::get('admin/parties_type/add', [PartiesTypeController::class, 'parties_type_add']);
       Route::post('admin/parties_type/add', [PartiesTypeController::class, 'parties_type_insert']);
       Route::get('admin/parties_type/edit/{id}', [PartiesTypeController::class, 'parties_type_edit']);           
       Route::post('admin/parties_type/edit/{id}', [PartiesTypeController::class, 'parties_type_update']);
       Route::get('admin/parties_type/delete/{id}', [PartiesTypeController::class, 'parties_type_delete']);
            
       Route::get('admin/parties', [PartiesTypeController::class, 'parties']);
       Route::get('admin/parties/add', [PartiesTypeController::class, 'parties_add']);
       Route::post('admin/parties/add', [PartiesTypeController::class, 'parties_insert']);
       Route::get('admin/parties/edit/{id}', [PartiesTypeController::class, 'parties_edit' ]);
       Route::post('admin/parties/edit/{id}', [PartiesTypeController::class, 'parties_update']);
       Route::get('admin/parties/delete/{id}', [PartiesTypeController::class, 'parties_delete']);


            


    });

Route::get('logout', [AuthControllerNew::class, 'logout']);
    





