@extends('admin.layouts.app')
@section('content')


    <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Parties Type</h1>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

      <!-- Main content -->
      <section class="content">
      <div class="container-fluid">
        @include('message')    
        <div class="row">
          <div class="col-md-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Parties Type list</h3>
                <a href="{{ url('admin/parties_type/add') }}" 
                class="btn btn-primary float-right">Add New Parties Type</a>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th style="width: 10px">SL No</th>
                      <th style="width: 80px">Parties Type  Name</th>                   
                      <th style="width: 80px">Transaction Type</th>                   
                      <th style="width: 40px">Action</th>
                    </tr>
                  </thead>
                  <tbody>
            @forelse($getRecord as $value)      
                    <tr>
                      <td>{{ $value->id }}</td>
                      <td>{{ $value->parties_type_name }}</td>
                      <td>
                        
                      </td>
                      <td>
                      <a href="{{ url('admin/parties_type/edit/'.$value->id) }}" 
                      class="btn btn-info"><i class="fas fa-pencil-alt"></i></a>
                      <a href="{{ url('admin/parties_type/delete/'.$value->id) }}" 
                      class="btn btn-danger" onclick="return confirm('Are you sure that you want to delete?')"> 
                        <i class="fas fa-trash"></i></a>
                      <a href="" class="btn btn-info">
                         <i class="fas fa-eye"></i></a>
                      </td>
                    </tr>
                    @empty
                    <tr>
                    <td colspan="100%">No record found in this page.</td>
                    </tr>
            @endforelse      
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
              <div class="card-footer clearfix">
                <ul class="pagination pagination-sm m-0 float-right">
                {!! $getRecord->appends(Illuminate\Support\Facades\Request::
                  except('page'))->links() !!}
                </ul>
              </div>
            </div>
     
          </div>
         
        </div>
      
 
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
    </div>
    

@endsection