<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\authcontroller;
use App\Http\Controllers\dashboardcontroller;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [authcontroller::class,'loginpage']);

Route::get('forgot', [authcontroller::class,'forgotpage']);

Route::post( 'login_post', [authcontroller::class, 'login_postPage']);

Route::post('forgot_post', [authcontroller::class, 'forgot_postpage']);

Route::group(['middleware' => 'admin'], function(){
Route::get('admin/dashboard', [dashboardcontroller::class,'dashboardpage']);

});

Route::get( 'logout', [authcontroller::class, 'logoutpage']);