<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PartiesTypeModel;
use App\Models\PartiesModel;

class PartiesTypeController extends Controller
{
    public function parties_type()
          {
            $data['getRecord'] = PartiesTypeModel::getRecordAll();
            return view('admin.parties_type.list', $data);
          }

    public function parties_type_add()
          {
            return view('admin.parties_type.add');
          }

    public function parties_type_insert(Request $request)
          {
            //dd($request->all());
            $save = request()->validate([
              'parties_type_name' => 'required'
            ]);

            $save = new PartiesTypeModel;
            $save->parties_type_name = trim($request->parties_type_name);
            $save->save();

            return redirect('admin/parties_type')->with('success', 'Record 
            successfully create');         
          }

    public function parties_type_edit($id, Request $request)
          {
            //dd($id);
            //$data['getRecord'] = PartiesTypeModel::find($id);
            $data['getRecord'] = PartiesTypeModel::singleGetRecord($id);
            return view('admin.parties_type.edit', $data);
          }

   public function parties_type_update($id, Request $request)
          {
            //dd($request->all());
            $save=PartiesTypeModel::singleGetRecord($id);
            $save->parties_type_name = trim($request->parties_type_name);
            $save->save();

            return redirect('admin/parties_type')->with('success', 'Record 
            successfully Updated');             
          }

   public function parties_type_delete($id)
          {
            //dd($id);
            $delete = PartiesTypeModel::singleGetRecord($id);
            $delete->delete();
            return redirect('admin/parties_type')->with('success', 'Record 
            successfully Delete');
          }

   public function parties()
          { 
          $data['getRecord'] = PartiesModel::getRecordAll();                   
            return view('admin.parties.list', $data);
          }

  public function parties_add()
          {
            $data['getPartiesType'] = PartiesTypeModel::get();
            return view('admin.parties.add', $data);
          }

public function parties_insert(Request $request)
          {
            //dd($request->all());
            $save = new PartiesModel;
            $save->parties_type_id = trim($request->parties_type_id);
            $save->full_name = trim($request->full_name);
            $save->phone_no = trim($request->phone_no);
            $save->address = trim($request->address);
            $save->account_holder_name = trim($request->account_holder_name);
            $save->account_no = trim($request->account_no);
            $save->bank_name = trim($request->bank_name);
            $save->ifc_code = trim($request->ifc_code);
            $save->branch_address = trim($request->branch_address);
            $save->save();
            return redirect('admin/parties')->with('success', 'Record 
            successfully create'); 
                  
          }

 public function parties_edit($id, Request $request)
          {
            //dd($id);
            $data['getRecord'] = PartiesModel::singleGetRecord($id);
            $data['getPartiesType'] = PartiesTypeModel::get();
                return view('admin.parties.edit', $data);
          }

 public function parties_update($id, Request $request)
          {
            $save = PartiesModel::singleGetRecord($id);
            $save->parties_type_id = trim($request->parties_type_id);
            $save->full_name = trim($request->full_name);
            $save->phone_no = trim($request->phone_no);
            $save->address = trim($request->address);
            $save->account_holder_name = trim($request->account_holder_name);
            $save->account_no = trim($request->account_no);
            $save->bank_name = trim($request->bank_name);
            $save->ifc_code = trim($request->ifc_code);
            $save->branch_address = trim($request->branch_address);
            $save->save();
            return redirect('admin/parties')->with('success', 'Record 
            successfully update'); 
          }

public function parties_delete($id)
          {
            //dd($id);
            $delete = PartiesModel::singleGetRecord($id);
            $delete->delete();
            return redirect('admin/parties')->with('success', 'Record 
            successfully Delete');
          }

          
}
