<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Str;
use Hash;
use Auth;
use App\Models\User;
use Mail;
use App\Mail\ForgotPasswordMail;


class AuthControllerNew extends Controller

{
    public function login (Request $request)
    {
        $data['meta_title'] = 'Login page';
        return view('auth.login', $data);
    }

    public function login_post(Request $request)
     {
        //dd($request->all());
        if(Auth::attempt(['email' => $request->email, 
               'password' => $request->password], true))
               {
                if(Auth::User()->is_role == '1')
                  {
                   return redirect()->intended('admin/dashboard');
                  }
                else{
                     return redirect('/')->with
                     ('error', 'Your requested Admin is not availabes');
                    }
               }
          else{
                return redirect()->back()->with('error', 'Please enter 
                your currect Credentials');
              } 
     }

    public function register (Request $request)
    {
        $data['meta_title'] = 'Register page';
        return view('auth.register', $data);
    }

    public function register_post (Request $request)
    {
        //dd($request->all());

        $user = request()->validate([
                'name' => 'required',
               'email' => 'required|unique:users',
            'password' => 'required|min:6'
        ]);

       $user = new User;
       $user->name = trim($request->name);
       $user->email = trim($request->email);
       $user->password = Hash::make($request->password);
       $user->remember_token = Str::random(50);
       $user->save();  

       return redirect('/')->with('success', 'Registrarion has done successfully.');

    }

    public function forgot_password (Request $request)
    {
        $data['meta_title'] = 'Forgot_Password page';
        return view('auth.forgot_password', $data);
    }

    public function forgot_password_post (Request $request)
    {
        //dd($request->all());
     
        
    }

    public function logout ()
    {
        Auth::logout();
        return redirect(url('/'));
    }




    
}
